<?php
header('Content-Type: application/json');
require_once __DIR__ . '/wp-load.php';

// Permitir CORS para que la app pueda llamar al endpoint
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type");

$input = json_decode(file_get_contents("php://input"), true);
$email = sanitize_email($input['email'] ?? '');
$password = $input['password'] ?? '';

if (empty($email) || empty($password)) {
    http_response_code(400);
    echo json_encode(["error" => "Email and password required"]);
    exit;
}

$user = wp_authenticate($email, $password);

if (is_wp_error($user)) {
    http_response_code(401);
    echo json_encode(["error" => "Invalid credentials"]);
    exit;
}

// Éxito: devolver id de usuario
echo json_encode([
    "userId" => $user->ID
]);